
;===============================================================================
; Function Name:	RegToVar
;===============================================================================
RegToVar(_regpath)
{
	_tampon := ""
	 _spos :=StringGetPos( _regpath, "\")
	_Key := StringLeft(_regpath, _spos)
	_spos ++
	_SubKey := StringTrimLeft(_regpath, _spos)
	_errors := 0
	Loop, %_Key%, %_Subkey%, 1, 1
		{
		IfEqual, A_LoopRegType, KEY
			Continue
		RegRead, A_Value
		_errors += ErrorLevel
		StringReplace, A_Value, A_Value, `n, ``n, A
		_tampon .= A_LoopRegType . "" . A_LoopRegKey . "" . A_LoopRegSubKey . "" . A_LoopRegName . "" . A_Value . "`n"
		}
	ErrorLevel := _errors
	; suppression du dernier LF
	StringTrimRight, _tampon, _tampon, 1
Return _tampon
}

;===============================================================================
; Function Name:	VarToReg
;===============================================================================
VarToReg(_reglist)
{
	_errors := 0
	Loop, Parse, _reglist, `n, `r
		{
		_ligne1 := _ligne2 := _ligne3 := _ligne4 := _ligne5 := ""
		StringSplit, _ligne, A_LoopField, 
		StringReplace, _ligne5, _ligne5, ``n, `n, A
		RegWrite, %_ligne1%, %_ligne2%, %_ligne3%, %_ligne4%, %_ligne5%
		_errors += ErrorLevel
		}
Return _errors
}

;===============================================================================
; Function Name:	RegToFile
;===============================================================================
RegToFile(_regpath, _file)
{
	_content := RegToVar(_regpath)
	If (_content && !ErrorLevel)
		{
		FileDelete, %_file%
		FileAppend, %_content%, %_file%
		}
	Else If ErrorLevel
		Return "readsource:" . ErrorLevel
Return ErrorLevel
}

;===============================================================================
; Function Name:	RegMove (on same hive)
;===============================================================================
RegMove(_regpathsource, _regpathdest)
{
	_orig := RegToVar(_regpathsource)
	If (_orig && !ErrorLevel)
		{
		_spos := StringGetPos( _regpathsource, "\") + 1
		_RootKey := StringLeft(_regpathsource, _spos - 1)
		_SubKeySource := StringTrimLeft(_regpathsource, _spos)
		_spos := StringGetPos( _regpathdest, "\") + 1
		_SubKeyDest := StringTrimLeft(_regpathdest, _spos)
		RegDelete, %_RootKey%, %_SubKeyDest%
		;If ErrorLevel
		;	Return "deletedest"
		StringReplace, _dest, _orig, %_SubKeySource%, %_SubKeyDest%, A
		_errors := VarToReg(_dest)
		If _errors
			Return "writereg:" . _errors
		RegDelete, %_RootKey%, %_SubKeySource%
		If ErrorLevel
			Return "deletesource"
		}
	Else If ErrorLevel
		Return "readsource:" . ErrorLevel
Return ErrorLevel
}
